function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = World_Economy_Cartel_cost_inv_shocks.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(76, 150);
g1(1,30)=T(35)+T(38);
g1(1,33)=T(35);
g1(1,11)=T(37);
g1(1,47)=exp(y(30))*exp(y(33))*T(86);
g1(1,48)=T(115);
g1(1,51)=T(116);
g1(1,65)=exp(y(30));
g1(1,22)=T(240);
g1(1,24)=T(36)*(-(exp(y(30))*T(27)));
g1(1,89)=(-1);
g1(1,135)=params(32);
g1(2,31)=T(29)*(-T(22))+T(22)*y(69)+y(79)*(-(T(34)*params(4)*params(4)*exp(y(31)*params(4))));
g1(2,47)=(-T(22))*T(86);
g1(2,48)=T(118);
g1(2,54)=T(119);
g1(2,69)=T(22);
g1(2,79)=(-(T(34)*params(4)*exp(y(31)*params(4))));
g1(2,91)=(-1);
g1(2,137)=params(32);
g1(3,32)=y(78)*(-(T(32)*params(4)*params(4)*exp(y(32)*params(4))))+T(39)+y(74)*y(43)*T(32)*params(4)*(params(4)-1)*(params(4)-1)*exp(y(32)*(params(4)-1));
g1(3,43)=y(74)*T(32)*params(4)*(params(4)-1)*exp(y(32)*(params(4)-1));
g1(3,53)=T(39);
g1(3,69)=T(21);
g1(3,74)=y(43)*T(32)*params(4)*(params(4)-1)*exp(y(32)*(params(4)-1));
g1(3,78)=(-(T(32)*params(4)*exp(y(32)*params(4))));
g1(3,90)=(-1);
g1(3,136)=params(32);
g1(4,30)=T(35);
g1(4,33)=T(29)*T(41)+y(82)*(-exp(y(33)))+exp(y(33))*y(81);
g1(4,47)=T(41)*T(86);
g1(4,48)=T(41)*T(99);
g1(4,56)=T(29)*(-T(40));
g1(4,63)=T(113);
g1(4,81)=exp(y(33));
g1(4,82)=(-exp(y(33)));
g1(4,93)=(-1);
g1(4,139)=params(32);
g1(5,34)=y(82)*(-exp(y(34)))+exp(y(34))*y(80);
g1(5,80)=exp(y(34));
g1(5,82)=(-exp(y(34)));
g1(5,92)=(-1);
g1(5,138)=params(32);
g1(6,35)=T(43);
g1(6,39)=T(50);
g1(6,115)=T(42);
g1(6,121)=params(32)*exp(y(35))*params(6)*exp(y(115))*exp(params(5)*y(39));
g1(6,77)=exp(y(35));
g1(6,124)=params(32)*(-(exp(y(35))*(1-exp(y(39)))));
g1(6,128)=params(32)*(-(exp(y(35))*exp(y(39))));
g1(7,36)=T(46);
g1(7,40)=T(120);
g1(7,116)=T(44);
g1(7,121)=params(32)*exp(y(36))*exp(params(5)*y(40))*params(6)*exp(y(116));
g1(7,76)=exp(y(36));
g1(7,123)=params(32)*(-((1-exp(y(40)))*exp(y(36))));
g1(7,127)=params(32)*(-(exp(y(40))*exp(y(36))));
g1(8,37)=T(47);
g1(8,77)=(-(params(7)*exp(y(37))));
g1(8,79)=exp(y(37));
g1(8,126)=params(32)*(-((1-params(7))*exp(y(37))));
g1(9,38)=T(48);
g1(9,76)=(-(params(7)*exp(y(38))));
g1(9,78)=exp(y(38));
g1(9,125)=params(32)*(-((1-params(7))*exp(y(38))));
g1(10,35)=T(50);
g1(10,39)=params(32)*(-exp(y(39)))*y(134)+T(122);
g1(10,115)=T(49);
g1(10,121)=T(238);
g1(10,124)=params(32)*(-(exp(y(35))*(-exp(y(39)))));
g1(10,128)=params(32)*(-(exp(y(35))*exp(y(39))));
g1(10,134)=params(32)*(-exp(y(39)));
g1(11,105)=y(72)*T(117);
g1(11,36)=T(120);
g1(11,40)=T(45)+T(56)+T(128)+T(130)+params(32)*y(121)*exp(y(36))*params(6)*exp(y(116))*params(5)*params(5)*exp(params(5)*y(40));
g1(11,106)=y(72)*(-(exp(y(113))*(-exp(y(40)))));
g1(11,113)=T(52)+T(54);
g1(11,115)=T(232);
g1(11,116)=T(55);
g1(11,121)=T(239);
g1(11,72)=T(53);
g1(11,75)=T(51);
g1(11,123)=params(32)*(-(exp(y(36))*(-exp(y(40)))));
g1(11,127)=params(32)*(-(exp(y(40))*exp(y(36))));
g1(12,41)=exp(y(41))*y(68);
g1(12,68)=exp(y(41));
g1(13,11)=T(36)*y(22)*(-(T(27)*(-exp(y(11)))));
g1(13,51)=T(131);
g1(13,22)=T(36)*(-(T(27)*(1-exp(y(11)))));
g1(13,72)=1;
g1(13,73)=(-params(7));
g1(13,24)=T(27)*T(36);
g1(14,32)=y(74)*T(32)*params(4)*(params(4)-1)*exp(y(32)*(params(4)-1));
g1(14,51)=T(36)*y(23)*(-(T(27)*(1-params(7))));
g1(14,23)=T(36)*(-(T(27)*(1-params(7))));
g1(14,73)=1;
g1(14,74)=params(4)*exp(y(32)*(params(4)-1))*T(32);
g1(15,44)=T(8)*y(82)+y(65)*(-(params(11)*T(12)*T(134)))+y(64)*(-(T(59)*T(138)+params(11)*T(58)*params(11)*T(58)*T(139)));
g1(15,45)=y(65)*(-(T(57)*params(11)*T(60)));
g1(15,13)=y(64)*(-(params(11)*T(58)*T(139)*T(154)));
g1(15,47)=y(64)*(-(params(11)*T(58)*T(96)*T(139)));
g1(15,52)=y(64)*(-(params(11)*T(58)*T(108)*T(139)));
g1(15,64)=(-(params(11)*T(58)*T(59)));
g1(15,65)=(-(params(11)*T(12)*T(57)));
g1(15,82)=T(8);
g1(16,44)=y(65)*(-(T(57)*params(11)*T(60)));
g1(16,45)=y(69)*(-exp(y(45)))+y(67)*(-(T(5)*T(19)*T(16)*exp(T(1)*y(52))*(1-params(11))*params(3)*T(144)))+y(66)*(-(T(17)*T(3)*T(16)*exp(T(1)*y(52))*(1-params(11))*(1-params(3))*T(144)))+exp(y(45))*y(64)+y(65)*(-(T(14)*params(11)*T(144)));
g1(16,13)=y(67)*T(156)+y(66)*(-(T(17)*T(157)));
g1(16,47)=T(145);
g1(16,52)=T(148);
g1(16,64)=exp(y(45));
g1(16,65)=(-(T(14)*params(11)*T(60)));
g1(16,66)=(-(T(17)*T(3)*T(16)*T(62)));
g1(16,67)=(-(T(5)*T(19)*T(16)*T(61)));
g1(16,69)=(-exp(y(45)));
g1(16,94)=(-1);
g1(16,140)=params(32);
g1(17,108)=params(32)*y(117)*(-(T(69)*params(11)*T(140)*T(141)));
g1(17,109)=params(32)*y(118)*(-(T(73)*(T(65)*T(76)*T(150)+T(66)*T(78)*T(150))))+params(32)*y(119)*T(151);
g1(17,46)=T(20)*y(69)+params(32)*y(121)*(-(T(20)*(1-params(10))))+params(32)*y(117)*(-(T(72)*T(170)+T(69)*T(69)*T(141)))+params(32)*y(118)*(-(T(73)*(T(75)*T(76)*T(168)+T(65)*T(75)*T(78)+T(65)*T(75)*T(78)+T(66)*T(75)*T(172))))+params(32)*y(119)*(-(T(64)*(T(78)*T(80)*T(81)+T(79)*T(80)*T(172)+T(78)*T(80)*T(81)+T(76)*T(80)*T(175))))+params(32)*y(120)*(-(exp((1-params(3))*y(110))*exp(T(1)*y(114))*params(3)*params(3)*exp(params(3)*y(46))));
g1(17,110)=params(32)*y(117)*(-(T(72)*T(207)+T(69)*T(141)*T(63)*T(68)*T(66)*T(206)))+params(32)*y(118)*(-((T(65)*T(75)*T(76)+T(66)*T(75)*T(78))*T(208)+T(73)*(T(65)*T(75)*T(77)*T(66)*T(206)+T(66)*T(75)*T(209))))+params(32)*y(119)*(-((T(79)*T(78)*T(80)+T(76)*T(80)*T(81))*T(206)+T(64)*(T(79)*T(80)*T(209)+T(81)*T(80)*T(77)*T(66)*T(206))))+params(32)*y(120)*(-(exp(T(1)*y(114))*params(3)*exp(params(3)*y(46))*(1-params(3))*exp((1-params(3))*y(110))));
g1(17,114)=params(32)*y(117)*(-(T(72)*T(228)+T(69)*T(141)*T(70)*(1-params(11))*T(1)*exp(T(1)*y(114))))+params(32)*y(118)*(-(T(73)*T(230)))+params(32)*y(119)*(-(T(64)*T(231)))+params(32)*y(120)*(-(exp((1-params(3))*y(110))*params(3)*exp(params(3)*y(46))*T(1)*exp(T(1)*y(114))));
g1(17,117)=params(32)*(-(T(69)*T(72)));
g1(17,118)=params(32)*(-(T(73)*(T(65)*T(75)*T(76)+T(66)*T(75)*T(78))));
g1(17,119)=params(32)*T(82);
g1(17,120)=params(32)*(-(exp((1-params(3))*y(110))*exp(T(1)*y(114))*params(3)*exp(params(3)*y(46))));
g1(17,69)=T(20);
g1(17,121)=params(32)*(-(T(20)*(1-params(10))));
g1(18,30)=exp(y(30))*exp(y(33))*T(86);
g1(18,31)=(-T(22))*T(86);
g1(18,33)=T(41)*T(86);
g1(18,44)=y(64)*(-(T(96)*params(11)*T(58)*T(139)));
g1(18,45)=T(145);
g1(18,13)=y(68)*(-(T(87)*exp(T(1)*y(52))*params(3)*exp(y(13)*params(3))))+y(67)*(-(T(89)*(T(19)*T(18)*T(90)*T(153)+T(16)*T(18)*T(155))+T(5)*(T(18)*T(91)*T(155)+T(19)*T(18)*T(159))))+y(66)*(-(T(17)*(T(15)*T(91)*T(152)+T(3)*T(15)*T(159))+T(93)*T(160)))+y(64)*(-(T(96)*T(139)*T(154)+T(59)*T(162)));
g1(18,14)=y(71)*T(180);
g1(18,47)=(T(41)-T(22))*T(187)+y(71)*(-(params(1)*T(187)/T(31)))+T(4)*y(70)+y(68)*(-(exp(T(1)*y(52))*exp(y(13)*params(3))*(1-params(3))*T(87)))+y(67)*T(192)+y(66)*T(196)+y(64)*(-(T(96)*T(96)*T(139)+T(59)*T(197)))+params(32)*y(122)*T(199);
g1(18,110)=params(32)*y(122)*(-((-(T(86)*T(213)))/(T(29)*T(29))));
g1(18,15)=y(71)*T(214);
g1(18,48)=(T(41)-T(22))*T(216)+y(71)*(-(params(1)*T(216)/T(31)))+params(32)*y(122)*T(218);
g1(18,111)=params(32)*y(122)*(-((-(T(86)*params(1)*exp(y(111))*T(212)))/(T(29)*T(29))));
g1(18,52)=y(68)*(-(T(87)*exp(y(13)*params(3))*T(1)*exp(T(1)*y(52))))+T(203)+T(204)+y(64)*(-(T(59)*T(205)+T(96)*T(108)*T(139)));
g1(18,54)=(-T(22))*T(86);
g1(18,56)=T(86)*(-T(40));
g1(18,63)=T(86)*T(112);
g1(18,64)=(-(T(59)*T(96)));
g1(18,66)=T(94);
g1(18,67)=T(92);
g1(18,68)=T(88);
g1(18,70)=T(4);
g1(18,71)=(-(params(1)*T(86)/T(31)));
g1(18,122)=params(32)*(-((-(T(86)*T(98)))/(T(29)*T(29))));
g1(19,30)=T(115);
g1(19,31)=T(118);
g1(19,33)=T(41)*T(99);
g1(19,14)=y(71)*T(181);
g1(19,47)=(T(41)-T(22))*T(200)+y(71)*(-(params(1)*T(200)/T(31)))+params(32)*y(122)*(-(T(201)/T(198)));
g1(19,110)=params(32)*y(122)*(-((-(T(99)*T(213)))/(T(29)*T(29))));
g1(19,15)=y(71)*T(215);
g1(19,48)=(T(41)-T(22))*T(219)+y(71)*(-(params(1)*T(219)/T(31)))+exp(y(48))*y(69)+params(32)*y(122)*(-((T(29)*T(29)*(-(T(98)*T(219)))-(-(T(98)*T(99)))*T(217))/T(198)));
g1(19,111)=params(32)*y(122)*(-((-(T(99)*params(1)*exp(y(111))*T(212)))/(T(29)*T(29))));
g1(19,54)=T(118);
g1(19,56)=T(99)*(-T(40));
g1(19,63)=T(99)*T(112);
g1(19,69)=exp(y(48));
g1(19,71)=T(100);
g1(19,122)=params(32)*(-((-(T(98)*T(99)))/(T(29)*T(29))));
g1(20,49)=exp(y(49))*y(67)+T(101);
g1(20,51)=T(101);
g1(20,67)=exp(y(49));
g1(20,21)=T(36)*(-(exp(y(49))*T(27)));
g1(21,50)=exp(y(50))*y(66)+y(70)*(-(T(25)*T(222)));
g1(21,66)=exp(y(50));
g1(21,70)=(-(T(25)*T(102)));
g1(22,30)=T(116);
g1(22,11)=T(124);
g1(22,42)=T(131);
g1(22,43)=T(36)*y(23)*(-(T(27)*(1-params(7))));
g1(22,49)=T(101);
g1(22,51)=T(104);
g1(22,55)=T(223);
g1(22,21)=T(36)*(-(T(27)*(1+exp(y(49))-params(10))));
g1(22,71)=T(27);
g1(22,22)=T(36)*T(103);
g1(22,23)=T(36)*(-(y(43)*T(27)*(1-params(7))));
g1(22,24)=T(36)*(T(27)*params(6)*params(5)*exp(y(55))*exp(y(11)*(params(5)-1))-T(27)*(exp(y(30))-y(42)));
g1(23,44)=y(64)*(-(T(108)*params(11)*T(58)*T(139)));
g1(23,45)=T(148);
g1(23,13)=y(68)*T(163)+y(67)*(-(T(5)*T(164)))+y(66)*(-(T(17)*T(165)))+y(64)*(-(T(108)*T(139)*T(154)+T(59)*T(107)*T(95)*T(153)));
g1(23,47)=y(68)*(-(T(87)*exp(y(13)*params(3))*T(1)*exp(T(1)*y(52))))+T(203)+T(204)+y(64)*(-(T(108)*T(96)*T(139)+T(59)*T(205)));
g1(23,52)=y(68)*T(225)+y(67)*(-(T(5)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(52))))+y(66)*T(226)+y(64)*(-(T(108)*T(108)*T(139)+T(59)*T(227)));
g1(23,64)=(-(T(59)*T(108)));
g1(23,66)=(-(T(17)*T(3)*T(16)*T(106)));
g1(23,67)=(-(T(5)*T(19)*T(16)*T(105)));
g1(23,68)=(-(exp(y(47)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(52))));
g1(23,83)=1;
g1(23,129)=params(32)*(-params(15));
g1(23,141)=T(109)*(-params(16));
g1(24,32)=T(39);
g1(24,53)=T(39)+y(74)*(-exp(y(53)));
g1(24,69)=T(21);
g1(24,74)=(-exp(y(53)));
g1(24,84)=1;
g1(24,130)=params(32)*(-params(18));
g1(24,142)=T(109)*(-params(19));
g1(25,31)=T(119);
g1(25,47)=(-T(22))*T(86);
g1(25,48)=T(118);
g1(25,54)=T(119);
g1(25,69)=T(22);
g1(25,85)=1;
g1(25,131)=params(32)*(-params(21));
g1(25,143)=T(109)*(-params(22));
g1(26,6)=T(24)*y(69);
g1(26,10)=y(69)*T(121);
g1(26,11)=T(125);
g1(26,51)=T(223);
g1(26,55)=T(110);
g1(26,69)=T(24);
g1(26,22)=T(241);
g1(26,24)=T(242);
g1(26,86)=1;
g1(26,132)=params(32)*(-params(24));
g1(26,144)=T(109)*(-params(25));
g1(27,33)=T(29)*(-T(40));
g1(27,7)=T(23)*y(69);
g1(27,11)=y(69)*T(126);
g1(27,47)=T(86)*(-T(40));
g1(27,48)=T(99)*(-T(40));
g1(27,56)=T(29)*(-T(40))+T(23)*y(69);
g1(27,63)=T(113);
g1(27,69)=T(23);
g1(27,87)=1;
g1(27,133)=params(32)*(-params(27));
g1(27,145)=T(109)*(-params(28));
g1(28,89)=1;
g1(29,90)=1;
g1(30,91)=1;
g1(31,92)=1;
g1(32,93)=1;
g1(33,94)=1;
g1(34,33)=T(113);
g1(34,47)=T(86)*T(112);
g1(34,48)=T(99)*T(112);
g1(34,56)=T(113);
g1(34,63)=exp(y(63))*y(88)+T(237);
g1(34,88)=exp(y(63));
g1(35,44)=(-(params(11)*T(58)*T(59)));
g1(35,45)=exp(y(45));
g1(35,13)=(-(T(59)*T(154)));
g1(35,47)=(-(T(59)*T(96)));
g1(35,52)=(-(T(59)*T(108)));
g1(36,30)=exp(y(30));
g1(36,44)=(-(params(11)*T(12)*T(57)));
g1(36,45)=(-(T(14)*params(11)*T(60)));
g1(37,45)=(-(T(17)*T(3)*T(16)*T(62)));
g1(37,13)=(-(T(17)*T(160)));
g1(37,47)=T(94);
g1(37,50)=exp(y(50));
g1(37,52)=(-(T(17)*T(3)*T(16)*T(106)));
g1(38,45)=(-(T(5)*T(19)*T(16)*T(61)));
g1(38,13)=(-(T(5)*(T(19)*T(18)*T(90)*T(153)+T(16)*T(18)*T(155))));
g1(38,47)=T(92);
g1(38,49)=exp(y(49));
g1(38,52)=(-(T(5)*T(19)*T(16)*T(105)));
g1(39,41)=exp(y(41));
g1(39,13)=(-(exp(y(47)*(1-params(3)))*exp(T(1)*y(52))*params(3)*exp(y(13)*params(3))));
g1(39,47)=T(88);
g1(39,52)=(-(exp(y(47)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(52))));
g1(40,31)=T(22);
g1(40,32)=T(21);
g1(40,6)=T(24);
g1(40,7)=T(23);
g1(40,10)=T(121);
g1(40,11)=T(126);
g1(40,45)=(-exp(y(45)));
g1(40,13)=(-(exp(y(13))*(1-params(10))));
g1(40,46)=T(20);
g1(40,48)=exp(y(48));
g1(40,53)=T(21);
g1(40,54)=T(22);
g1(40,55)=T(24);
g1(40,56)=T(23);
g1(41,47)=T(4);
g1(41,50)=(-(T(25)*T(102)));
g1(42,112)=(-(exp(y(113))*exp(y(112))));
g1(42,113)=(-(exp(y(113))*(1+exp(y(112))-params(10))));
g1(43,14)=(-((-(params(1)*T(29)*T(179)))/(T(31)*T(31))));
g1(43,47)=(-(params(1)*T(86)/T(31)));
g1(43,15)=(-((-(params(1)*T(29)*exp(y(15))*T(178)))/(T(31)*T(31))));
g1(43,48)=T(100);
g1(43,51)=T(27);
g1(44,105)=T(117);
g1(44,40)=T(53);
g1(44,42)=1;
g1(44,106)=(-(exp(y(113))*(1-exp(y(40)))));
g1(44,113)=T(224);
g1(44,115)=(-(exp(y(113))*(-(params(6)*exp(y(115))*exp(params(5)*y(40))))));
g1(45,42)=(-params(7));
g1(45,43)=1;
g1(45,107)=(-(exp(y(113))*(1-params(7))));
g1(45,113)=(-(exp(y(113))*(1-params(7))*y(107)));
g1(46,32)=y(43)*T(32)*params(4)*(params(4)-1)*exp(y(32)*(params(4)-1));
g1(46,43)=params(4)*exp(y(32)*(params(4)-1))*T(32);
g1(46,53)=(-exp(y(53)));
g1(47,105)=(-(exp(y(113))*exp(y(105))));
g1(47,40)=T(51);
g1(47,106)=exp(y(113));
g1(47,113)=T(114);
g1(47,115)=T(33);
g1(48,7)=(-(exp(y(7))*(1-exp(y(11)))));
g1(48,36)=exp(y(36));
g1(48,38)=(-(params(7)*exp(y(38))));
g1(48,11)=(-(exp(y(7))*(-exp(y(11)))));
g1(49,6)=(-(exp(y(6))*(1-exp(y(10)))));
g1(49,35)=exp(y(35));
g1(49,37)=(-(params(7)*exp(y(37))));
g1(49,10)=(-(exp(y(6))*(-exp(y(10)))));
g1(50,32)=(-(T(32)*params(4)*exp(y(32)*params(4))));
g1(50,9)=(-((1-params(7))*exp(y(9))));
g1(50,38)=exp(y(38));
g1(51,31)=(-(T(34)*params(4)*exp(y(31)*params(4))));
g1(51,8)=(-((1-params(7))*exp(y(8))));
g1(51,37)=exp(y(37));
g1(52,34)=exp(y(34));
g1(52,7)=(-(exp(y(7))*exp(y(11))));
g1(52,11)=(-(exp(y(7))*exp(y(11))));
g1(53,33)=exp(y(33));
g1(53,6)=(-(exp(y(6))*exp(y(10))));
g1(53,10)=(-(exp(y(6))*exp(y(10))));
g1(54,33)=(-exp(y(33)));
g1(54,34)=(-exp(y(34)));
g1(54,44)=T(8);
g1(55,16)=(-params(15));
g1(55,52)=1;
g1(55,150)=(-1);
g1(55,25)=(-params(16));
g1(56,17)=(-params(18));
g1(56,53)=1;
g1(56,147)=(-1);
g1(56,26)=(-params(19));
g1(57,18)=(-params(21));
g1(57,54)=1;
g1(57,146)=(-1);
g1(57,27)=(-params(22));
g1(58,19)=(-params(24));
g1(58,55)=1;
g1(58,149)=(-1);
g1(58,28)=(-params(25));
g1(59,20)=(-params(27));
g1(59,56)=1;
g1(59,148)=(-1);
g1(59,29)=(-params(28));
g1(60,10)=(-exp(y(10)));
g1(60,63)=exp(y(63));
g1(61,1)=1;
g1(61,30)=(-1);
g1(61,57)=1;
g1(62,3)=1;
g1(62,32)=(-1);
g1(62,58)=1;
g1(63,2)=1;
g1(63,31)=(-1);
g1(63,59)=1;
g1(64,5)=1;
g1(64,34)=(-1);
g1(64,60)=1;
g1(65,4)=1;
g1(65,33)=(-1);
g1(65,61)=1;
g1(66,12)=1;
g1(66,45)=(-1);
g1(66,62)=1;
g1(67,129)=(-1);
g1(67,95)=1;
g1(68,130)=(-1);
g1(68,96)=1;
g1(69,131)=(-1);
g1(69,97)=1;
g1(70,132)=(-1);
g1(70,98)=1;
g1(71,133)=(-1);
g1(71,99)=1;
g1(72,16)=(-1);
g1(72,100)=1;
g1(73,17)=(-1);
g1(73,101)=1;
g1(74,18)=(-1);
g1(74,102)=1;
g1(75,19)=(-1);
g1(75,103)=1;
g1(76,20)=(-1);
g1(76,104)=1;

end
